package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.BufferedWriter;

public class RedEnemyScreenObject extends ScreenObject implements CloneableScreenObject {
	
	
	private IntRect clickRect;
	
	private boolean isSelected;
	
	public static final int ENEMY_WIDTH = 64;
	public static final int ENEMY_HEIGHT = 64;
	
	
	private static CustomImageDataII redEnemyImage;
	
	
	private static synchronized void loadRedEnemyImage(ImageObserver io) {
		
		redEnemyImage = new CustomImageDataII("/images/enemy/red/elemental R red 1.GIF", Color.white, io);
		
	}
	
	
	public RedEnemyScreenObject(int x, int y, ImageObserver io) {
		
		if(redEnemyImage == null) {
			loadRedEnemyImage(io);
		}
		
		clickRect = new IntRect(x - ENEMY_WIDTH/2, y - ENEMY_HEIGHT/2, ENEMY_WIDTH, ENEMY_HEIGHT);
		isSelected = false;
		
	}
	
	
	
	@Override
	public void draw(Graphics g) {
		if(redEnemyImage != null) {
			redEnemyImage.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		}
		if(isSelected)
			drawSelectionOverObject(g);
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	@Override
	public void setSelected(boolean is) {
		isSelected = is;
	}

	@Override
	public boolean isSelected() {
		return isSelected;
	}


	@Override
	public void setClickRect(IntRect newRect) {
		// TODO Auto-generated method stub
		
	}
	
	
	public void writeOutToFile(BufferedWriter out) throws Exception{
		
		out.write("enemy:");
		out.newLine();
		
		Point centerPoint = clickRect.getCenter();
		
		out.write("x:");
		out.write(Integer.toString(centerPoint.x));
		out.newLine();
		
		out.write("y:");
		out.write(Integer.toString(centerPoint.y));
		out.newLine();
		
		out.write("red");
		out.newLine();
		
		out.write("dir:l");
		out.newLine();
		
		out.write("/enemy");
		out.newLine();
		
		out.newLine();
	}
	
	
	public RedEnemyScreenObject clone(ImageObserver io) {
		
		Point centerPoint = clickRect.getCenter();
		RedEnemyScreenObject returnValue = new RedEnemyScreenObject(centerPoint.x, centerPoint.y, io);
		return returnValue;
		
	}
	
	
	@Override
	public int getLayer() {
		
		return 14;
	}
}
